package gov.va.vamf.scheduling.direct.domain;

import agilex.commons.NullChecker;
import com.agilex.healthcare.veteranappointment.domain.Namespace;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;

@Document(collection="clinical-services")
@XmlRootElement(name = "clinical-service", namespace = Namespace.VeteranAppointmentRequest)
@XmlAccessorType(value = XmlAccessType.NONE)
public class ClinicalService extends DomainBaseObject {

    @XmlElement
    String name;
    @XmlElement
    StopCodes stopCodes;
    @XmlElement
    int submittedRequestLimit;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StopCodes getStopCodes() {
        return stopCodes;
    }

    public void setStopCodes(StopCodes stopCodes) {
        this.stopCodes = stopCodes;
    }

    public int getSubmittedRequestLimit() {
        return submittedRequestLimit;
    }

    public void setSubmittedRequestLimit(int submittedRequestLimit) {
        this.submittedRequestLimit = submittedRequestLimit;
    }

    public String getStopCodesAsString() {
        return getStopCodesAsString(this.stopCodes);
    }

    public static String getStopCodesAsString(StopCodes stopCodes) {
        Collection<String> stopCodesStringsList = new ArrayList<String>();

        for(StopCode stopCode : stopCodes) {
            String primary = stopCode.getPrimary();
            String secondary = stopCode.getSecondary();
            boolean secondTerm = NullChecker.isNotNullish(secondary);

            String stopCodeString = "[" + primary + (secondTerm ? "," + secondary : "") + "]";
            stopCodesStringsList.add(stopCodeString);
        }

        return StringUtils.join(stopCodesStringsList.toArray(), ',');
    }
}
